from khovanov_lee_complex import *
from knot_utilities import NPlusMinus
from knot_examples import *
from collections import defaultdict
import gc

####### KHOVANOV HOMOLOGY ##############

### Includes the function:

## KhovanovLeeHomology(K,Prime)

def KhovanovLeeHomology(K, Prime, Max_Crossing_Number = 14, Verbose = True): 
    if IsKnot(K) == False:
        print("Not a knot")
        return

    Inverse = {}
    for i in range(1,Prime):
        for j in range(1,Prime):
            if (i*j)%Prime == 1:
                Inverse[i] = j
    
    n_plus, n_minus = NPlusMinus(K)
    n_crossings = n_plus+n_minus
    if n_crossings > Max_Crossing_Number:
        print("Number Of Crossings > ", Max_Crossing_Number)
        print("Terminating computation")
        return 
    Gens, Arrows = KhovanovLeeComplex(K, Max_Crossing_Number)
    print("Number of generators", len(Gens))
    print("Number of arrows", len(Arrows)) 
    From = {}
    To = {}
    IsDeleted = {}

    for i in range(len(Gens)):
        From[i] = []
        To[i] = []
        IsDeleted[i] = False
        
    for Head, Tail, Sign in Arrows:
        From[Head].append((Tail, Sign%Prime))
        To[Tail].append((Head, Sign%Prime))

    del Arrows
    gc.collect()

    Priority = []
    for i in range(len(Gens)):
        a, b = Gens[i]
        c = len(From[i]) + len(To[i])
        Priority.append((a, b, c, i))

    Priority.sort()
    Priority = [x[3] for x in Priority]

    steps_to_go = len(Gens)
    for Level in range(n_crossings+1):
        deleted_pairs = 0
        for i in Priority:
            steps_to_go-=1          
            if Verbose and (steps_to_go)% 100000 == 0 and Level == 0:
                print("Remaining Generators to Check : ", steps_to_go)

            if IsDeleted[i] : continue
            Candidates = From[i]
            if len(Candidates) == 0:
                continue
            
            # Selecting a cancelling pair (i,j):
            SmallPriority = []
            G1 = Gens[i]
            for j, value in Candidates:
                G2 = Gens[j]
                if G2[1] == G1[1] + 4*Level:
                    SmallPriority.append((len(To[j]),j, value))
            if len(SmallPriority) == 0: continue
            SmallPriority.sort()
            j = SmallPriority[0][1]
            coeff = SmallPriority[0][2]

            for x, v1 in To[j]:
                if x in [i,j]: continue 
                D = defaultdict(int)
                for y, v2 in From[i]:
                    if y not in [i,j]:
                        D[y] += (-Inverse[coeff]*v1*v2)
                for y, v3 in From[x]:
                    if y not in [i,j]:
                        D[y] += v3
                Updated = []
                for y in D:
                    v = D[y]%Prime
                    if v != 0:
                        Updated.append((y,v))
                From[x] = Updated

        
            for y, v1 in From[i]: 
                if y in [i,j]: continue
                D = defaultdict(int)
                for x, v2 in To[j]:
                    if x not in [i,j]:
                        D[x] += (-Inverse[coeff]*v1*v2)
                for x, v3 in To[y]:
                    if x not in [i,j]:
                        D[x] += v3
                Updated = []
                for x in D:
                    v = D[x]%Prime
                    if v != 0:
                        Updated.append((x,v))
                To[y] = Updated
            
                  
            # Delete all traces of i and j:
            for w, _ in To[i]:
                if w in [i,j]: continue
                Old = From[w]
                From[w] = [z_pair for z_pair in Old if z_pair[0] not in [i,j]]
            for w, _ in From[j]:
                if w in [i,j]: continue
                Old = To[w]
                To[w] = [z_pair for z_pair in Old if z_pair[0] not in [i,j]]
            From[i] = []
            To[i]   = []
            From[j] = []
            To[j]   = []
            IsDeleted[i] = True
            IsDeleted[j] = True
            deleted_pairs +=1
        if deleted_pairs == 0:
            break


    TotalRank = 0
    NewGens = defaultdict(int)
    for i in IsDeleted:
        if IsDeleted[i] == False:
            bigrading = Gens[i]
            NewGens[bigrading]+=1
            TotalRank+=1

    print("Total Rank", TotalRank)
    Ranks = []
    for bigrading in NewGens:
        a, b = bigrading
        value = NewGens[bigrading]
        Ranks.append((a,b,value))
    Ranks.sort()
    return  tuple(Ranks)
                
            
            

        
                                 
    


    
