from khovanov_complex import *
from knot_utilities import NPlusMinus
from collections import defaultdict
import gc

####### KHOVANOV HOMOLOGY ##############

### Includes the function:

## KhovanovHomology(K,Prime)

def KhovanovHomology(K, Prime, Max_Crossing_Number = 14, Verbose = True): 
    if IsKnot(K) == False:
        print("Not a knot")
        return

    Inverse = {}
    for i in range(1,Prime):
        for j in range(1,Prime):
            if (i*j)%Prime == 1:
                Inverse[i] = j
    
    n_plus, n_minus = NPlusMinus(K)
    n_crossings = n_plus+n_minus
    if n_crossings > Max_Crossing_Number:
        print("Number Of Crossings > ", Max_Crossing_Number)
        print("Terminating computation")
        return 
    Gens, Arrows = KhovanovComplex(K, Max_Crossing_Number)
    print("Number of generators", len(Gens))
    print("Number of arrows", len(Arrows)) 
    From = {}
    To = {}
    IsDeleted = {}
        
    for i in range(len(Gens)):
        From[i] = []
        To[i] = []
        IsDeleted[i] = False
        
    for Head, Tail, Sign in Arrows:
        From[Head].append((Tail, Sign%Prime))
        To[Tail].append((Head, Sign%Prime))

    del Arrows
    gc.collect()

    Priority = []
    for i in range(len(Gens)):
        a, b = Gens[i]
        c = len(From[i]) + len(To[i])
        Priority.append((a, b, c, i))

    Priority.sort()
    Priority = [x[3] for x in Priority]

    steps_to_go = len(Gens)
    for i in Priority:
        if Verbose and (steps_to_go)% 10000 == 0:
            print("Remaining Generators to Check : ", steps_to_go)
        steps_to_go-=1
        if IsDeleted[i]:
            continue
        Candidates = From[i]
        if len(Candidates) == 0:
            continue

        # Selecting a cancelling pair (i,j):
        SmallPriority = []
        for j, value in Candidates:
            SmallPriority.append((len(To[j]),j, value))
        SmallPriority.sort()
        j = SmallPriority[0][1]
        coeff = SmallPriority[0][2]

        # If \partial([i]) has coefficient coeff != 0  at [j], then we
        # use a change of basis in the homological grading Gr of i:
        # F([i]) = [i] and for x in homological grading Gr:
        # F([x]) = [x]-(q*Inverse(coeff))\cdot [i], where where \partial([x]) has coefficient q at generator [j]

        # What are the new boundary maps after this change of basis:

        # For maps into homological grading Gr:
        # If \partial([w]) = b\cdot [i] +sum_k a_k \cdot   [x_k],  then we claim that
        #    \partial([w]) = 0\cdot [i] +sum_k a_k \cdot [F(x_k)]:

        # The difference is (b + Inverse(coeff)*(sum_k (a_k*q_k))\cdot [i].
        # Since we are in a chain complex : \partial^2([w]) at [j] = 0.
        # This implies:  b*coeff + sum_k (a_k*q_k) = 0.
        # So the difference is 0, as claimed.

        # For maps out of homological grading Gr:
        # \partial([F(x_k)]) = \partial([x_k]) - q_k*Inverse(coeff)\cdot(\partial([i])),
        # and so the coefficient of \partial([F(x_k)]) at [j] is
        # q_k - q_k*Inverse(coeff)*coeff = 0.

        # It follows that in the new basis those generators that are not equal to [i] or [j] generate a subcomplex.
        # Since the quotient complex (generated by [i] and [j]) has trivial homology, (coeff != 0 and we work over a field), 
        # the original homology is the same as the homology of this subcomplex.

        # In practice we just delete the generators [i] and [j] and update the coefficients by the formula:
        # NewPartial([x_k]) = OldPartial([x_k]) - q_k*Inverse(coeff)\cdot(OldPartial([i]))

        # So we have the old arrows between the remaining generators
        # and we also add the new terms called zig-zags:
        # If there was an arrow from x_k to j and from i to y_p,
        # then we add a new arrow from x_k to y_p.

        # Update the arrows out of x (for all x that are connected to j):
        for x, v1 in To[j]:
            if x in [i,j]: continue 
            D = defaultdict(int)
            for y, v2 in From[i]:
                if y not in [i,j]:
                    D[y] += (-Inverse[coeff]*v1*v2)
            for y, v3 in From[x]:
                if y not in [i,j]:
                    D[y] += v3
            Updated = []
            for y in D:
                v = D[y]%Prime
                if v != 0:
                    Updated.append((y,v))
            From[x] = Updated

        # Update the arrows into y (for all y that are connected to i):    
        for y, v1 in From[i]: 
            if y in [i,j]: continue
            D = defaultdict(int)
            for x, v2 in To[j]:
                if x not in [i,j]:
                    D[x] += (-Inverse[coeff]*v1*v2)
            for x, v3 in To[y]:
                if x not in [i,j]:
                    D[x] += v3
            Updated = []
            for x in D:
                v = D[x]%Prime
                if v != 0:
                    Updated.append((x,v))
            To[y] = Updated
            
                  
        # Delete all traces of i and j:
        for w, _ in To[i]:
            if w in [i,j]: continue
            Old = From[w]
            From[w] = [z_pair for z_pair in Old if z_pair[0] not in [i,j]]
        for w, _ in From[j]:
            if w in [i,j]: continue
            Old = To[w]
            To[w] = [z_pair for z_pair in Old if z_pair[0] not in [i,j]]
        From[i] = []
        To[i]   = []
        From[j] = []
        To[j]   = []
        IsDeleted[i] = True
        IsDeleted[j] = True

    TotalRank = 0
    NewGens = defaultdict(int)
    for i in IsDeleted:
        if IsDeleted[i] == False:
            bigrading = Gens[i]
            NewGens[bigrading]+=1
            TotalRank+=1

    print("Total Rank", TotalRank)
    Ranks = []
    for bigrading in NewGens:
        a, b = bigrading
        value = NewGens[bigrading]
        Ranks.append((a,b,value))
    Ranks.sort()
    return  tuple(Ranks)
                
            
            

        
                                 
    


    
