from knot_examples import *
from knot_utilities import *
from alexander1 import *
from seifert import *
from knot_signature import *
from knotfloer1 import *

###### INCLUDED FUNCTIONS #####

#### In knot_examples:

## Unknot(), LHT(), RHT(). # Basic examples: unknot, left-handed trefoil, right-handed-trefoil.
## Torus(p,q), # Torus knots, p,q is relatively prime.
## Pretzel(a,b,c) # Three stranded pretzel knots, at most one of a, b, c is even.
## Conway() # The Conway knot.
## KT() # The Kinoshita-Terasaka knot.
## Mirror(K) # Changes all the crossings in the projection. It represents the mirror of the knot.
## Reverse(K) # Adds 1 more crossing close to the global minimum. It represents the reverse of the knot.

#### In knot_utilities:

## IsKnot(K)
## PositiveQuadrants(K)
## PosNegCrossings(K)
## NPlusMinus(K)
## Writhe(K)
## BadCrossings(K)
## IsAlternatingProjection(K)

#### In alexander1:

## Alexander(K) # The symmetric Alexander polynomial, computed using Kauffman states. 
## PrintAlexander(K)
## KnotDeterminant(K) # Alexander(K) evaluated at -1.

#### In seifert:

## GenusFromSeifertAlgorithm(K) # Implements the Seifert algorithm and computes genus.
## GenusBounds(K) # Uses the Alexander polynomial and the Seifert algorithm.

#### In knot_signature:

## KnotSignatureForAlternating(K) # It assumes that K is an alternating diagram.
## KnotSignature(K) # Computes the signature for a general knot.

#### In knot_floer1:

## KnotFloerGenerators(K)
## GenusBounds2(K) # Computes a slightly improved upper bound using Kauffman states. 

