from collections import defaultdict
from knot_utilities import IsKnot, PositiveQuadrants
from alexander1 import Alexander

########## ALEXANDER POLYNOMIAL ############

### Includes the functions:
## GenusFromSeifertAlgorithm
## GenusBounds

def GenusFromSeifertAlgorithm(K):
    """
    For a knot diagram K it runs the Seifert algorithm and returns the genus of the corresponding Seifert surface.
    """

    if IsKnot(K) == False:
        print("Not a knot")
        return
    
    Dict_Crossing = PositiveQuadrants(K)
    M = [1,0] # The matching of strands in the oriented resolution 
    Circles = 0

    for step in range(1,len(K)-1):
        c = K[step]
        if c > 100: # Adding a Maximum.
            s = c-101
            M = [p if p < s else p+2 for p in M[:s]]+[s+1,s]+[p if p < s else p+2 for p in M[s:]]
                                                              
            
        elif c < -100: # Adding a Minimum. 
            s = -c-101
            s1 = M[s]
            s2 = M[s+1]
            if s1 != s+1:
                M[s1] = s2
                M[s2] = s1
            else:
                Circles+=1

            M = M[:s]+M[s+2:]
            M = [p if p < s else p-2 for p in M]
             
            
        else :
            s = abs(c)-1 
            Q = Dict_Crossing[step]
            if Q in ['E', 'W']:
                s1 = M[s]
                s2 = M[s+1]
                if s1 != s+1:
                    M[s1]  = s2
                    M[s2]  = s1
                    M[s]   = s+1
                    M[s+1] = s
                else :
                    Circles += 1
    Circles += 1
    Euler_Char = Circles - len(Dict_Crossing) # Equals to 1-2g

    return (-Euler_Char+1)//2


def GenusBounds(K):
    """
    For a knot diagram K it returns a range for the possible values for the Seifert genus of K.
    
    The upper bound for genus of the Seifert surface given by Seifert's algorithm for the projection.
    The lower bound is the degree of the symetrized Alexander polynomial.

    It returns [lower_bound, upper_bound].
    """

    if IsKnot(K) == False:
        print("Not a knot")
        return

    List1 = Alexander(K)
    d, _ = List1[-1] # The maximal non-trivial term in the Alexander polynomial

    g_min = d
    g_max = GenusFromSeifertAlgorithm(K)

    return [g_min, g_max]


