
##### KNOT EXAMPLES #####

### Included Functions:

## Unknot()
## LHT()
## RHT()
## Torus(p,q)
## Pretzel(a,b,c)
## Conway()
## KT() 
## Mirror(K)
## Reverse(K)


def Unknot():
    return ((101, -101))


def RHT():
    return ((101,101,2,2,2,-101,-101))


def LHT():
    return ((101,101,-2,-2,-2,-101,-101))


def Torus(p,q):
    """
    Returns a diagram for the torus link T(p,q).
    Note that T(p,q)=T(q,p)=T(-p,-q), and T(p,-q) = Mirror(T(p,q).
    Note that T(p,q) is a knot if and only if (p,q)=1.
    """
    if min(abs(p), abs(q)) > 49:
        print("Too Large Values")
        return 
    t = p*q
    if t > 0: t =  1
    if t < 0: t = -1
    if t == 0:
        print("p and q are not allowed to be 0")
        return 0
    p = abs(p)
    q = abs(q) 
    if q < p:
        p, q = q, p
    K = []
    for i in range(p):
        K.append(100+i+1)
    for i in range(q):
        for j in range(p-1):
            K.append(t*(p-1-j))
    for i in range(p):
        K.append(-100-p+i)
    return tuple(K)


def Pretzel(a,b,c):
    """
    Returns a diagram for the three stranded pretzel link P(a,b,c).
    Positive values indicate right-handed twists, negative values indicate left-handed twists.
    Example: Pretzel(1,1,1) The left handed trefoil LFT.
    Example: Pretzel(1,-1,1) the unknot.
    Example: Pretzel(-3,5,7). (A non-trivial knot with trivial Alexander polynomial).
    Note that P(a,b,c) is a knot if and only if at least two of a, b and c are odd.
    """

    K = [101,102,104]
    if a > 0:
        K+=([1]*a)
    if a < 0:
        K+=([-1]*abs(a))
    if b > 0:
        K+=([3]*b)
    if b < 0:
        K+=([-3]*abs(b))
    if c > 0:
        K+=([5]*c)
    if c < 0:
        K+=([-5]*abs(c))
    K+=[-102,-102,-101]
    return tuple(K)


def Conway():
    """
    Returns a 12-crossing a presentation for the Conway knot.
    """
    K = (101,101,2,2,102,106,1,1,-3,-3,-3,-5,-5,7,7,7,-102, -102, -102,-101)
    return K


def KT():
    """
    Returns a 12-crossing presentation for the Kinoshita-Terasaka knot.
    """
    K = (101,101,2,2,102,106,1,1,-3,-3,-3,5,5,5,-7,-7,-102, -102, -102,-101)
    return K


def Mirror(K):
    """ 
    Returns a diagram for the Mirror of K.
    """
    return tuple([x if abs(x)> 100 else -x for x in K])


def Reverse(K):
    """
    Adds a Reidemeister 1 move at the last minimum.
    Since the knot is oriented from left to right at the last minimum, 
    the new projection represents the reverse of K.
    """
    return tuple(list(K[:-1])+[1, -101])



